#!/bin/bash

echo "🚀 PPSP Data Destruction App - Setup Script"
echo "============================================"

# Check if Node.js is installed
if ! command -v node &> /dev/null; then
    echo "❌ Node.js is not installed. Please download from https://nodejs.org/"
    exit 1
fi

echo "✅ Node.js version: $(node --version)"

# Install dependencies
echo "📦 Installing dependencies..."
npm install

# Check installation
if [ $? -eq 0 ]; then
    echo "✅ Dependencies installed successfully"
else
    echo "❌ Failed to install dependencies"
    exit 1
fi

echo ""
echo "🎉 Setup complete!"
echo ""
echo "Next steps:"
echo "  1. Run 'npm start' to test the app"
echo "  2. Run 'npm run build:mac' to create installer"
echo ""
echo "⚠️  Note: This app simulates wiping for safety."
echo "   Edit src/main.js to enable real drive wiping."
