#!/bin/bash
echo "🍎 Building PPSP Secure Wipe for macOS..."
cd "$(dirname "$0")/mac-app"

# Check Node.js
if ! command -v node &> /dev/null; then
    echo "❌ Node.js not found. Install from https://nodejs.org/"
    exit 1
fi

echo "📦 Installing dependencies..."
npm install

echo "🔨 Building..."
npm run build:mac

if [ $? -eq 0 ]; then
    echo "✅ Build successful!"
    echo "📍 Output: mac-app/dist/PPSP Secure Wipe.dmg"
    open dist/
else
    echo "❌ Build failed"
    exit 1
fi
